CREATE TABLE fonction(
	libfonction VARCHAR(20) PRIMARY KEY,
	agemini SMALLINT NOT NULL,
	agemaxi SMALLINT
);

CREATE TABLE habitant(
	nom VARCHAR(20) PRIMARY KEY,
	adresse VARCHAR(40) NOT NULL,
	datnaiss DATE NOT NULL,
	libfonction VARCHAR(20) REFERENCES fonction(libfonction) NOT NULL
);

CREATE TABLE bataille(
	bataille CHAR(6) PRIMARY KEY,
	lieu VARCHAR(20) NOT NULL,
	datcombat DATE NOT NULL,
	legions SMALLINT NOT NULL,
	issue SMALLINT NOT NULL
);

CREATE TABLE poisson(
	espece VARCHAR(20) PRIMARY KEY,
	prixkilo MONEY NOT NULL,
	origine CHAR(1) NOT NULL
);

CREATE TABLE potion(
	nompotion VARCHAR(20) PRIMARY KEY
);

CREATE TABLE combattre(
	nom VARCHAR(20) REFERENCES habitant(nom),
	bataille CHAR(6) REFERENCES bataille(bataille),
	casques SMALLINT NOT NULL,
	PRIMARY KEY (nom, bataille)
);

CREATE TABLE manger(
	nom VARCHAR(20) REFERENCES habitant(nom),
	espece VARCHAR(20) REFERENCES poisson(espece),
	datachpoi DATE NOT NULL,
	nbkilo SMALLINT NOT NULL,
	PRIMARY KEY (nom, espece, datachpoi)
);

CREATE TABLE prendre(
	nom VARCHAR(20) REFERENCES habitant(nom),
	nompotion VARCHAR(20) REFERENCES potion(nompotion),
	dateprise DATE NOT NULL,
	qtepotion NUMERIC(2, 1) NOT NULL,
	PRIMARY KEY (nom, nompotion, dateprise)
);

CREATE TABLE menhir(
	nromen SMALLINT PRIMARY KEY,
	hauteur SMALLINT NOT NULL,
	poids SMALLINT NOT NULL,
	prix MONEY NOT NULL,
	nom VARCHAR(20) REFERENCES habitant(nom),
	datachmen DATE,
	prixvente MONEY
);
