--create schema rugby;
SET SCHEMA 'rugby';

CREATE TABLE
    equipe (
        code_equipe CHAR(3) PRIMARY KEY,
        nom_entraineur CHAR(40) NOT NULL,
        nom_president CHAR(40) NOT NULL,
        pays CHAR(40) NOT NULL
    );

CREATE TABLE
    joueur (
        num_joueur SMALLINT PRIMARY KEY,
        nom_joueur CHAR(40) NOT NULL,
        age_joueur SMALLINT,
        code_equipe CHAR(3),
        FOREIGN KEY (code_equipe) REFERENCES EQUIPE (code_equipe),
        CONSTRAINT ck_age_joueur CHECK (age_joueur > 0)
    );

CREATE TABLE
    rencontre (
        num_match SMALLINT PRIMARY KEY,
        nom_stade CHAR(40) NOT NULL,
        equipe_accueil CHAR(3) NOT NULL,
        equipe_deplacement CHAR(3) NOT NULL,
        prime_match_gagne NUMERIC(6, 2),
        score_equipe_accueil SMALLINT,
        score_equipe_deplacement SMALLINT,
        equipe_gagnante CHAR(3),
        date_match DATE NOT NULL,
        FOREIGN KEY (equipe_accueil) REFERENCES EQUIPE (code_equipe),
        FOREIGN KEY (equipe_deplacement) REFERENCES EQUIPE (code_equipe),
        FOREIGN KEY (equipe_gagnante) REFERENCES EQUIPE (code_equipe),
        CONSTRAINT ck_score_equipe_accueil CHECK (score_equipe_accueil >= 0),
        CONSTRAINT ck_score_equipe_deplacement CHECK (score_equipe_deplacement >= 0)
    );

CREATE TABLE
    participer (
        num_joueur SMALLINT,
        num_match SMALLINT,
        titulaire BOOLEAN NOT NULL DEFAULT FALSE,
        PRIMARY KEY (num_joueur, num_match),
        FOREIGN KEY (num_joueur) REFERENCES JOUEUR (num_joueur),
        FOREIGN KEY (num_match) REFERENCES RENCONTRE (num_match)
    );

ALTER TABLE rencontre ADD COLUMN nb_spectateurs INTEGER;