SET SCHEMA 'rugby';

-- R1 :
SELECT DISTINCT nom_stade FROM rencontre ORDER BY nom_stade;

-- R2 :
SELECT
    nom_joueur,
    age_joueur,
    pays
FROM joueur
    JOIN equipe USING (code_equipe)
WHERE age_joueur > 35;

-- R3 :
SELECT date_match
FROM rencontre
    JOIN equipe ON code_equipe = equipe_accueil
WHERE pays = 'Irlande';

-- R4 :
SELECT COUNT(*)
FROM joueur
    JOIN equipe USING (code_equipe)
    JOIN participer USING (num_joueur)
    JOIN rencontre USING (num_match)
WHERE
    pays = 'France'
    AND date_match = '2020-02-02';

-- R5 :
SELECT nom_joueur
FROM joueur
    JOIN equipe USING (code_equipe)
    JOIN participer USING (num_joueur)
    JOIN rencontre USING (num_match)
WHERE
    titulaire = FALSE
    AND pays = 'Angleterre'
    AND date_match = '2020-02-08';

-- R6 :
SELECT AVG(nb_spectateurs)
FROM rencontre
WHERE
    nom_stade = 'Stade de France';

-- R7:
SELECT SUM(prime_match_gagne)
FROM rencontre
    JOIN participer p USING(num_match)
    JOIN joueur j USING(num_joueur)
    JOIN equipe e ON equipe_gagnante = e.code_equipe
WHERE
    pays = 'Angleterre'
    AND j.code_equipe = e.code_equipe;

-- R7 bis:
SELECT SUM(prime_match_gagne)
FROM rencontre
    JOIN participer USING(num_match)
    JOIN joueur USING(num_joueur)
    JOIN equipe USING(code_equipe)
WHERE
    pays = 'Angleterre'
    AND equipe_gagnante = code_equipe;

-- R8:
SELECT
    MAX(
        ABS(
            score_equipe_accueil - score_equipe_deplacement
        )
    )
FROM rencontre;

-- R9:
SELECT
    num_match,
    a.pays,
    score_equipe_accueil,
    d.pays,
    score_equipe_deplacement
FROM rencontre
    JOIN equipe a ON equipe_accueil = a.code_equipe
    JOIN equipe d ON equipe_deplacement = d.code_equipe
WHERE
    ABS(
        score_equipe_accueil - score_equipe_deplacement
    ) IN (
        SELECT
            MAX(
                ABS(
                    score_equipe_accueil - score_equipe_deplacement
                )
            )
        FROM rencontre
    );

-- R10:
SELECT pays, COUNT(*)
FROM joueur
    JOIN equipe USING(code_equipe)
WHERE age_joueur > 30
GROUP BY code_equipe, pays
ORDER BY COUNT(*) DESC;

-- R11:
SELECT pays, COUNT(*)
FROM joueur
    JOIN equipe USING(code_equipe)
WHERE age_joueur < 25
GROUP BY code_equipe, pays
HAVING COUNT(*) >= 5
ORDER BY COUNT(*) DESC;

-- R12:
SELECT nom_joueur
FROM joueur
    JOIN equipe USING(code_equipe)
WHERE
    pays = 'France'
    AND num_joueur NOT IN (
        SELECT num_joueur
        FROM participer
            JOIN rencontre USING(num_match)
        WHERE
            date_match = '09/02/2020'
    )
ORDER BY nom_joueur;