SET SCHEMA 'ventes';

CREATE TABLE
    categories(
        codecategorie INT NOT NULL,
        nomcategorie VARCHAR(25),
        description TEXT
    );

CREATE TABLE
    clients(
        codeclient VARCHAR(5) NOT NULL,
        societe VARCHAR(40) NOT NULL,
        contact VARCHAR(30),
        fonction VARCHAR(30),
        adresse VARCHAR(60),
        ville VARCHAR(25),
        region VARCHAR(25),
        codepostal VARCHAR(10),
        pays VARCHAR(15),
        telephone VARCHAR(24),
        fax VARCHAR(24)
    );

CREATE TABLE
    commandes(
        nocommande INT NOT NULL,
        codeclient VARCHAR(5) NOT NULL,
        noemploye INT NOT NULL,
        datecommande DATE,
        alivreravant DATE,
        dateenvoi DATE,
        port DECIMAL(19, 4)
    );

CREATE TABLE
    comporter(
        nocommande INT NOT NULL,
        refproduit INT NOT NULL,
        prixunitaire DECIMAL(19, 4) NOT NULL,
        quantite SMALLINT NOT NULL,
        remise FLOAT NOT NULL
    );

CREATE TABLE
    employes(
        noemploye INT NOT NULL,
        nom VARCHAR(20) NOT NULL,
        prenom VARCHAR(10) NOT NULL,
        fonction VARCHAR(30),
        datenaissance DATE,
        dateembauche DATE,
        adresse VARCHAR(60),
        ville VARCHAR(15),
        region VARCHAR(15),
        codepostal VARCHAR(10),
        pays VARCHAR(15),
        teldomicile VARCHAR(24),
        poste VARCHAR(4),
        notes TEXT,
        rendcompte INT
    );

CREATE TABLE
    fournisseurs(
        nofournisseur INT NOT NULL,
        societe VARCHAR(40) NOT NULL,
        contact VARCHAR(30),
        fonction VARCHAR(40),
        adresse VARCHAR(60),
        ville VARCHAR(15),
        region VARCHAR(15),
        codepostal VARCHAR(10),
        pays VARCHAR(15),
        telephone VARCHAR(24),
        fax VARCHAR(24)
    );

CREATE TABLE
    produits(
        refproduit INT NOT NULL,
        nofournisseur INT,
        codecategorie INT,
        nomproduit VARCHAR(40) NOT NULL,
        prixunitaire DECIMAL(19, 4),
        unitesenstock SMALLINT,
        unitescommandees SMALLINT,
        niveaureappro SMALLINT
    );