-- 1:
SELECT
    DISTINCT societe,
    adresse,
    codepostal,
    ville,
    pays
FROM clients
    JOIN commandes USING(codeclient)
WHERE
    region = 'WA'
    AND datecommande BETWEEN '01/01/2021' AND '15/02/2022';

-- 2:
SELECT COUNT(*) FROM clients WHERE pays = 'Mexique';

-- 3:
SELECT
    nocommande,
    alivreravant
FROM commandes
WHERE
    alivreravant < NOW()
    AND dateenvoi IS NULL;

-- 3 bis: (incluant les commandes précédentes)
SELECT
    nocommande,
    alivreravant
FROM commandes
WHERE (
        alivreravant < NOW()
        AND dateenvoi IS NULL
    )
    OR alivreravant < dateenvoi;

-- 4:
SELECT
    AVG(dateenvoi - alivreravant)
FROM commandes
WHERE alivreravant < dateenvoi;

-- 5:
SELECT
    nomproduit,
    unitesenstock,
    niveaureappro,
    nomcategorie
FROM produits
    JOIN categories USING(codecategorie)
WHERE
    unitesenstock + unitescommandees < niveaureappro;

-- 6:
SELECT refproduit, nomproduit
FROM produits
WHERE unitesenstock > (
        SELECT
            AVG(unitesenstock)
        FROM produits
    );

-- 7:
SELECT
    pays,
    COUNT(*) Nb_Fournisseurs
FROM fournisseurs
GROUP BY(pays)
ORDER BY Nb_Fournisseurs DESC;

-- 8:
SELECT
    s.nom,
    s.fonction,
    e.nom,
    e.fonction
FROM employes s
    JOIN employes e ON e.rendcompte = s.noemploye
ORDER BY s.nom;

-- 9:
SELECT
    ROUND(
        SUM(
            prixunitaire * (1 - remise) * quantite
        )
    ) chiffre_affaire
FROM comporter
    JOIN commandes USING(nocommande)
WHERE
    datecommande BETWEEN '01-01-2022' AND '31-12-2022';

-- 9 avec port:
SELECT
    ROUND(SUM(prix)) chiffre_affaire
FROM (
        SELECT
            SUM(
                prixunitaire * (1 - remise) * quantite
            ) + port prix
        FROM comporter
            JOIN commandes USING(nocommande)
        WHERE
            datecommande BETWEEN '01-01-2022' AND '31-12-2022'
        GROUP BY
            nocommande,
            port
    ) s;

-- 10:
SELECT
    pays,
    societe,
    ROUND(
        SUM(
            prixunitaire * (1 - remise) * quantite
        )
    ) chiffre_affaire
FROM comporter
    JOIN commandes USING(nocommande)
    JOIN clients USING(codeclient)
GROUP BY
    codeclient,
    societe,
    pays
HAVING
    SUM(
        comporter.prixunitaire * (1 - remise) * quantite
    ) > 200000
ORDER BY chiffre_affaire DESC;

-- 10 bis:
SELECT
    pays,
    societe,
    ROUND(SUM(prix)) chiffre_affaire
FROM (
        SELECT
            SUM(
                prixunitaire * (1 - remise) * quantite
            ) + port prix,
            codeclient
        FROM comporter
            JOIN commandes USING(nocommande)
        GROUP BY
            nocommande,
            codeclient,
            port
    ) s
    JOIN clients USING(codeclient)
GROUP BY
    codeclient,
    societe,
    pays
HAVING SUM(prix) > 200000
ORDER BY chiffre_affaire DESC;

-- 11:
SELECT pays FROM clients EXCEPT SELECT pays FROM fournisseurs;

-- 12:
SELECT refproduit, nomproduit
FROM produits
WHERE refproduit NOT IN (
        SELECT refproduit
        FROM comporter
            JOIN commandes USING(nocommande)
        WHERE
            datecommande BETWEEN '01-09-2023' AND NOW()
    );

-- 13:
SELECT societe
FROM fournisseurs
    JOIN produits USING(nofournisseur)
    JOIN categories USING(codecategorie)
GROUP BY
    nofournisseur,
    societe
HAVING
    ANY(nomcategorie) = 'Condiments'
    AND ANY(nomcategorie) = 'Desserts';