/* ---------------------------------------------------------------------------
 * MachineCaracteres : lecture de caractères sur l'entrée standard (clavier)
 * jusqu'à fin de cette entrée (matérialisée par une marque).
 * Auteur(s)  : Damien Genthial (Alain Lucci pour la version Ada) 
 * Création   : Janvier 2001, modifié en décembre 2006
 *              puis en février 2008
 * Note :
 *  Ce module ne prétend pas être écrit dans un souci d'efficacité mais dans le
 *  souci de coller à la description algorithmique initiale, dont l'objectif
 *  est avant tout pédagogique.
 */

#include <stdio.h>
#include "MachineCaracteres.h"

/* Variables privées du module (déclarées "static") */
static unsigned int numeroLigne;
static char cc;			/* Caractère courant */
static const char MARQUEFIN = EOF;

/* ------- Procédures publiques ------- */

/* Initialise la machine avec le premier caractère du ruban */
void demarrerCar(void)
{
   numeroLigne = 1;
   cc = ' ';			/* pour le test du saut de ligne dans av_car */
   av_car();
}

/* Retourne le caractère courant*/
char carCourant(void)
{
   return cc;
}

/* Retourne le numéro de la ligne courante */
unsigned int numLigne(void)
{
   return numeroLigne;
}

/* Retourne la marque */
char marque(void)
{
   return MARQUEFIN;
}

/* Avance sur le prochain caractère, égal à marque() si on a atteint la fin
 * du ruban */
void av_car(void)
{
   if (cc == '\n')		/* on a lu un RC */
      numeroLigne = numeroLigne + 1;
   cc = getchar();
   /* MARQUEFIN == EOF, donc si EOF on ne fait rien */
   if (cc == '\f')		/* on transforme '\f' en '\n' */
      cc = '\n';
}
